import qrcode, json

def generate_qr_boolean_array(text):
    qr = qrcode.QRCode(
        version=5,
        error_correction=qrcode.constants.ERROR_CORRECT_Q,
        box_size=1,
        border=0,
    )
    
    qr.add_data(text)
    qr.make(fit=True)
    
    img = qr.make_image(fill_color="black", back_color="white")
    width, height = img.size
    
    boolean_array = []
    for y in range(height):
        row = []
        for x in range(width):
            pixel = img.getpixel((x, y))
            if pixel == 0 or pixel == (0, 0, 0): row.append(True)
            else: row.append(False)
        boolean_array.append(row)
    
    return boolean_array

print(json.dumps(generate_qr_boolean_array("Hello, world!")))